<?php
/* --------------------------------------------------------------
   SpecificWithdrawalRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalId;

/**
 * Class SpecificWithdrawalRequested
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class SpecificWithdrawalRequested
{
    /**
     * @var WithdrawalId
     */
    private $withdrawalId;
    
    
    /**
     * SpecificWithdrawalRequested constructor.
     *
     * @param WithdrawalId $withdrawalId
     */
    private function __construct(WithdrawalId $withdrawalId)
    {
        $this->withdrawalId = $withdrawalId;
    }
    
    
    /**
     * @param WithdrawalId $withdrawalId
     *
     * @return SpecificWithdrawalRequested
     */
    public static function create(WithdrawalId $withdrawalId): SpecificWithdrawalRequested
    {
        return new self($withdrawalId);
    }
    
    
    /**
     * @return WithdrawalId
     */
    public function withdrawalId(): WithdrawalId
    {
        return $this->withdrawalId;
    }
    
    
    /**
     * @param WithdrawalId $withdrawalId
     */
    public function replaceWithdrawalId(WithdrawalId $withdrawalId): void
    {
        $this->withdrawalId = $withdrawalId;
    }
}